document.addEventListener('DOMContentLoaded', () => {
    const sendButton = document.getElementById('sendButton');
    const emailInput = document.getElementById('emailInput');
    const idInput = document.getElementById('idInput');

    // Get 'id' parameter from query string
    const params = new URLSearchParams(window.location.search);
    const id = params.get('id');
    if (id) {
        idInput.value = id; // Set the hidden input value
    }

    // Basic validation and feedback
    if (sendButton && emailInput) {
        sendButton.addEventListener('click', (event) => {
            const email = emailInput.value;

            // Basic email validation
            if (!email || !email.includes('@')) {
                event.preventDefault(); // Prevent form submission
                alert('Please enter a valid email address.');
                emailInput.focus();
            }
        });
    }
});

